%% -- Read Data------------------------------
A = xlsread('data_firstpart_Left.xls'); %% read the data from the first part of the survey
[rowA, colA] = size(A);

%% --- Input the names of words --------------
ppmenu11string=[
    'None to Very Little            ';
    
    'Very Low                       ';
    'More or Less Low               ';
    
    'Low                            ';
   
    'From Fair to More or Less High ';
   
    'More or Less High              ';
    'High                           ';
  
    'Extremely High                 '];
ppmenu11string; %% Words for the FIRST SURVEY

MFsA=zeros(colA/2,9);
MeanOfLeftEndA=[]; %% mean of left-end
MeanOfRightEndA=[]; %% mean of right-end

%% ---- compute the FOUs and centroids FOR THE FIRST SURVEY --------------------
for i=1:colA/2
    %%disp('This is for')
    %%disp(ppmenu11string(i,:))
    LA = A(1:rowA, 2*i-1);  %%Read the left end points for interval data.
    RA = A(1:rowA, 2*i);    %%Read the right end points for interval data.
    [MFsA(i,:),nA(i),aA,bA] = Fuzzistics(LA,RA); %%Determine the interval type-2 MFs and the number of remaining interval data m* for each word.
    MeanOfLeftEndA(i,:)=aA;
    MeanOfRightEndA(i,:)=bA;    
    [CsA(i), ClA(i), CrA(i)]=centroid(MFsA(i,:)); %%Compute the center of the centroid and the centroid of interval type-2 MFs.
end

%% -- sort the MFs in ascending order according to the center of centroid FIRST SURVEY --
[CsA,indexA]=sort(CsA);  %% Sort the center of the centroid

% try to fix NVL>EL problem
% indexA=reorder(indexA,rowA,A);

MFsA=MFsA(indexA,:);     %% Reorder the MFs based on the sorting of the center of centroids
ClA=ClA(indexA);         %% Reorder the left end of the centroid.
CrA=CrA(indexA);         %% Reorder the right end of the centroid.
wordsA_DR=ppmenu11string(indexA,:); %%Reorder the names of words.
MeanOfLeftEndA=MeanOfLeftEndA(indexA,:);
MeanOfRightEndA=MeanOfRightEndA(indexA,:);

%% Jacard Similarity
S=zeros(colA/2,colA/2);
for i=1:colA/2
    for k=1:colA/2
        S(i,k)=Jaccard(MFsA(i,:), MFsA(k,:));
    end
end

disp('  ');
disp('  ');
disp('Similarity matrix for FIRST part of the esurvey');
S

figure
set(gcf,'DefaulttextFontName','times new roman');
set(gcf,'DefaultaxesFontName','times new roman');
set(gcf,'DefaulttextFontAngle','italic');
set(gcf,'DefaulttextFontSize',7);
for i=1:colA/2
   subplot(5,3,i);
   fill(MFsA(i,[1:4 8 7 6 5 1]),[0 1 1 0 0 MFsA(i,9) MFsA(i,9) 0 0],[0.9 0.9 0.9]);
   hold on;
   plot(MFsA(i,1:4),[0 1 1 0],'k','linewidth',1);%%upper
   hold on;
   plot(MFsA(i,5:8),[0 MFsA(i,9) MFsA(i,9) 0],'k','linewidth',1); %%lower
   title(wordsA_DR(i,:),'fontsize',7);
   set(gca,'YTick',[]);
   set(gca,'XTick',[]);
   axis([0 10 0 1]);
end
